package jp.mosp.common.part;

import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;

/**
 * aɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class JPDatePart extends BasePart {

	/**
	 * RXgN^
	 */
	public JPDatePart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public JPDatePart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * a\ݒ
	 * @param targetDate	Ώ۔N
	 * @return	a\
	 * @throws MospException
	 * @throws Exception
	 */
	public String getJapaneseDate(Date targetDate) throws MospException, Exception {
		return getDateString(
				mospconf().getConfList(CommonConst.CONF_ID_JP_IMP_CAL),
				cmcode().getJPCalendarGengo(),
				targetDate
		);
	}

	/**
	 * a\ݒ
	 * @param targetDate	Ώ۔N(yyyy-mm-dd)
	 * @return	a\
	 * @throws MospException
	 * @throws Exception
	 */
	public String getJapaneseDate(String targetDate) throws MospException, Exception {
		return getJapaneseDate(DatePart.convHyphenDateToDate(targetDate));
	}

	/**
	 * t擾(a)
	 * @param list a񃊃Xg
	 * @param date 
	 * @return t
	 * @throws MospException
	 */
	private String getDateString(List<MosPConfDto> list, String[][] aryEra, Date date) throws MospException {
		if (date == null || list == null) {
			return "";
		}
		String[] strDate = getJpImperialCal(list, date);
		strDate[0] = StringPart.getCodeName(strDate[0], aryEra);
		for (int i = 1; i < strDate.length; i++) {
			strDate[i] = strDate[i].length() < 2 ? CommonConst.SUPPRESS_DATE + strDate[i] : strDate[i];
		}
		StringBuffer sb = new StringBuffer();
		sb.append(strDate[0]);
		sb.append(strDate[1]);
		sb.append(CommonConst.NAM_YEAR);
		sb.append(strDate[2]);
		sb.append(CommonConst.NAM_MONTH);
		sb.append(strDate[3]);
		sb.append(CommonConst.NAM_DAY);
		return sb.toString();
	}

	/**
	 * a擾
	 * @param list a񃊃Xg
	 * @param date t
	 * @return tz
	 * @throws MospException 
	 */
	private String[] getJpImperialCal(List<MosPConfDto> list, Date date) throws MospException {
		String[] aryJpDate = new String[4];
		if (date == null) {
			return aryJpDate;
		}
		for (Iterator<MosPConfDto> it = list.iterator(); it.hasNext();) {
			MosPConfDto dto = it.next();
			Date startDate = getDate(dto.getConfCode ());
			Date endDate   = getDate(dto.getConfValue());
			if (startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0) {
				int year = MospUtility.getYear(date) - MospUtility.getYear(startDate) + 1;
				aryJpDate[0] = dto.getConfId();
				aryJpDate[1] = String.valueOf(year);
				aryJpDate[2] = String.valueOf(MospUtility.getMonth(date));
				aryJpDate[3] = String.valueOf(MospUtility.getDay  (date));
				return aryJpDate;
			}
		}
		throw new MospException(MospConst.EX_DATE_INVALID);
	}

	/**
	 * t擾(/p)
	 * @param strDate t
	 * @return t
	 * @throws MospException 
	 */
	private Date getDate(String strDate) throws MospException {
		if (strDate == null || strDate.length() != 8) {
			throw new MospException(MospConst.EX_DATE_INVALID);
		}
		return MospUtility.getDate(
				strDate.substring(0, 4) + CommonConst.SEPARATOR_DATE +
				strDate.substring(4, 6) + CommonConst.SEPARATOR_DATE +
				strDate.substring(6, 8)
		);
	}

}
